<?php
include 'db.php';
require('fpdf/fpdf.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Read the raw POST data (JSON)
    $inputData = json_decode(file_get_contents('php://input'), true);

                if ($inputData) {
                    // Get form data from the decoded JSON
                    $reportType = $inputData['report_type'];
                    $duration = $inputData['duration'];
                    $columns = isset($inputData['report_columns']) ? $inputData['report_columns'] : [];
                    $reportFormat = $inputData['report_format'];
                    $startDate = $inputData['start_date'] ?? null;
                    $endDate = $inputData['end_date'] ?? null;

                    if (empty($columns)) {
                        $columns = [
                           'Invoice Id', 'Invoice Date', 'Customer Name', 'Customer Mobile', 'Item Name',
                           'HSN', 'Quantity', 'Price Per Unit', 'SGST', 'SGST%', 'CGST',
                            'CGST%', 'IGST', 'IGST%', 'CESS', 'CESS%', 'Item Total'
                        ];
                    }
                    $query = "SELECT 
                    i.invoice_id, 
                    i.invoice_no, 
                    o.Order_id, 
                    o.order_no, 
                    i.created_date AS invoice_date, 
                    u.displayname AS Customer_Name, 
                    u.phoneno AS Customer_Mobile, 
                    pd.Product_name AS Product_Name, 
                    pd.HSN, 
                    id.qty, 
                    id.Selling_price
                FROM 
                    invoice i
                LEFT JOIN 
                    invoice_data id
                ON 
                    i.invoice_id = id.invoice_id
                LEFT JOIN 
                    orders o
                ON 
                    o.Invoice_id = i.invoice_id
                LEFT JOIN 
                    product pd 
                ON 
                    id.Product_id = pd.Product_id
                LEFT JOIN 
                    customer u 
                ON 
                    i.user_id = u.id
                WHERE 
                    i.Delete_status = 0";
                
                // Apply duration filters (last week, last month, etc.)
                if ($duration == "Today") {
                    $query .= " AND DATE(i.created_date) = CURDATE()";
                } elseif ($duration == "Yesterday") {
                    $query .= " AND DATE(i.created_date) = CURDATE() - INTERVAL 1 DAY";
                } elseif ($duration == "Last Week") {
                    $query .= " AND i.created_date >= NOW() - INTERVAL 1 WEEK";
                } elseif ($duration == "Last Month") {
                    $query .= " AND i.created_date >= NOW() - INTERVAL 1 MONTH";
                } elseif ($duration == "Custom" && $startDate && $endDate) {
                    $query .= " AND i.created_date BETWEEN '$startDate' AND '$endDate'";
                }
                
                
                $query .= " ORDER BY i.invoice_id";
                
                
                // Perform the query using MySQLi
                $result = $conn->query($query);
                $data = [];
                while ($row = $result->fetch_assoc()) {
                $data[] = $row;
                }
                
                // Generate the CSV file
                if ($reportFormat == "Xlsx") {
                $filePath = 'reports/GST_report_' . time() . '.csv';
                $file = fopen($filePath, 'w');
                
                // Write the header row
                $header = [];

                // Dynamically add columns to the header using the filter array
                if (in_array('Invoice ID', $columns)) $header[] = 'Invoice Id';
                if (in_array('Invoice Date', $columns)) $header[] = 'Invoice Date';
                if (in_array('Customer Name', $columns)) $header[] = 'Customer Name';
                if (in_array('Customer Mobile', $columns)) $header[] = 'Customer Mobile';
                if (in_array('Item Name', $columns)) $header[] = 'Item Name';
                if (in_array('HSN', $columns)) $header[] = 'HSN';
                if (in_array('Quantity', $columns)) $header[] = 'Quantity';
                if (in_array('Price Per Unit', $columns)) $header[] = 'Price Per Unit';
                if (in_array('SGST', $columns)) $header[] = 'SGST';
                if (in_array('SGST%', $columns)) $header[] = 'SGST%';
                if (in_array('CGST', $columns)) $header[] = 'CGST';
                if (in_array('CGST%', $columns)) $header[] = 'CGST%';
                if (in_array('IGST', $columns)) $header[] = 'IGST';
                if (in_array('IGST%', $columns)) $header[] = 'IGST%';
                if (in_array('CESS', $columns)) $header[] = 'CESS';
                if (in_array('CESS%', $columns)) $header[] = 'CESS%';
                if (in_array('Item Total', $columns)) $header[] = 'Item Total';

                // Write the header to the CSV file
                fputcsv($file, $header);
                
                // Write data rows
                foreach ($data as $row) {
                // Ensure values are properly aligned to headers
                $total=$row['Selling_price']*$row['qty'];
                $sgst_percent = 2.5;
                $cgst_percent = 2.5;
                $igst_percent = 5.0;
                $sgst = $total * ($sgst_percent / 100);
                $cgst = $total * ($cgst_percent / 100);
                $igst = $total * ($igst_percent / 100);
                
                foreach ($data as $row) {
                    $rowData = [];
                
                    // Dynamically add values to rowData based on header inclusion
                    if (in_array('Invoice ID', $columns)) $rowData[] = $row['invoice_no'];
                    if (in_array('Invoice Date', $columns)) $rowData[] = $row['invoice_date'];
                    if (in_array('Customer Name', $columns)) $rowData[] = $row['Customer_Name'];
                    if (in_array('Customer Mobile', $columns)) $rowData[] = $row['Customer_Mobile'];
                    if (in_array('Item Name', $columns)) $rowData[] = $row['Product_Name'];
                    if (in_array('HSN', $columns)) $rowData[] = $row['HSN'];
                    if (in_array('Quantity', $columns)) $rowData[] = $row['qty'];
                    if (in_array('Price Per Unit', $columns)) $rowData[] = $row['Selling_price'];
                    if (in_array('SGST', $columns)) $rowData[] = $sgst;
                    if (in_array('SGST%', $columns)) $rowData[] = $sgst_percent;
                    if (in_array('CGST', $columns)) $rowData[] = $cgst;
                    if (in_array('CGST%', $columns)) $rowData[] = $cgst_percent;
                    if (in_array('IGST', $columns)) $rowData[] = $igst;
                    if (in_array('IGST%', $columns)) $rowData[] = $igst_percent;
                    if (in_array('CESS', $columns)) $rowData[] = '0.0'; // Placeholder for CESS
                    if (in_array('CESS%', $columns)) $rowData[] = '0.0'; // Placeholder for CESS%
                    if (in_array('Item Total', $columns)) $rowData[] = $total;
                
                    // Write the row to the CSV file
                    fputcsv($file, $rowData);
                }}
                
                // Close the file
                fclose($file);
                
                $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
                $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
                $report_no_result = mysqli_query($conn, $report_no_query);
                $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
                $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
                $durationText = $duration ?? 'N/A';
                $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                          VALUES ('$reportNo','GST Report', NOW(), '$durationText', '$finalpath', 0)";
                $conn->query($insertQuery);
                
                echo json_encode(['status' => 'success', 'message' => 'Report generated successfully', 'file' => $finalpath]);
                } elseif ($reportFormat == "pdf") {
                $filePath = 'reports/GST_report_' . time() . '.pdf';
                
                // Create a new PDF document
                $pdf = new FPDF('L', 'mm', array(600, 670));
                
                $pdf->AddPage();
                $pdf->SetFont('Arial', 'B', 12);
                
                // Table headers
                $headers = [
                  'Invoice Id', 
                 'Invoice Date', 
                 'Customer Name', 
                 'Customer Mobile', 
                 'Item Name', 
                 'HSN', 
                 'Quantity', 
                 'Price Per Unit', 
                 'SGST', 
                 'SGST%', 
                 'CGST', 
                 'CGST%', 
                 'IGST', 
                 'IGST%', 
                 'CESS', 
                 'CESS%', 
                 'Item Total'
                ];
                
                // Set column widths
                $colWidths = array_fill(0, count($headers), 38); // Adjust column widths as needed
                $rowHeight = 8;
                
                // Print header row
                foreach ($headers as $index => $header) {
                $pdf->Cell($colWidths[$index], $rowHeight, $header, 1, 0, 'C');
                }
                $pdf->Ln(); // Move to the next row
                
                // Print data rows
                foreach ($data as $row) {
                    $total=$row['Selling_price']*$row['qty'];
                $sgst_percent = 2.5;
                $cgst_percent = 2.5;
                $igst_percent = 5.0;
                $sgst = $total * ($sgst_percent / 100);
                $cgst = $total * ($cgst_percent / 100);
                $igst = $total * ($igst_percent / 100);
                $values = [
                    $row['invoice_no'], 
                    $row['invoice_date'],  
                    $row['Customer_Name'], 
                    $row['Customer_Mobile'],
                    $row['Product_Name'], 
                    $row['HSN'], 
                    $row['qty'], 
                    $row['Selling_price'], 
                    $sgst,         
                    $sgst_percent, 
                    $cgst,         
                    $cgst_percent, 
                    $igst,         
                    $igst_percent, 
                    '0.0',         
                    '0.0',         
                    $total
                ];
                
                foreach ($values as $index => $value) {
                  $pdf->Cell($colWidths[$index], $rowHeight, $value, 1, 0, 'C');
                }
                $pdf->Ln(); // Move to the next row
                }
                
                // Save the PDF file
                $pdf->Output('F', $filePath);
                
                $report_no_query = "SELECT MAX(Reports_id) AS max_id FROM reports";
                $finalpath = "https://hapitest.xyz/hapi%20commers/api/" . $filePath;
                $report_no_result = mysqli_query($conn, $report_no_query);
                $max_id = mysqli_fetch_assoc($report_no_result)['max_id'] ?? 0;
                $reportNo = 'REP_' .  str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);  
                $durationText = $duration ?? 'N/A';
                $insertQuery = "INSERT INTO reports (Report_no,report_name, date, Duration, Excel_path, Delete_status) 
                         VALUES ('$reportNo','GST report', NOW(), '$durationText', '$finalpath', 0)";
                $conn->query($insertQuery);
                
                echo json_encode(['status' => 'success', 'message' => 'PDF report generated successfully', 'file' => $finalpath]);
                } else {
                echo json_encode(['status' => 'error', 'message' => 'Invalid report format']);
                }
                
                }
            }
?>